<?php
/**
 * Timber starter-theme
 * https://github.com/timber/starter-theme
 */

// Load Composer dependencies.
require_once __DIR__ . '/vendor/autoload.php';

require_once __DIR__ . '/src/StarterSite.php';

Timber\Timber::init();

// Sets the directories (inside your theme) to find .twig files.
Timber::$dirname = [ 'templates', 'views' ];

new StarterSite();

function theninja_widgets_init() {
    register_sidebar( array(
        'name'          => __( 'Footer Column 1', 'theninja' ),
        'id'            => 'footer-column-1',
        'description'   => __( 'Widgets in this area will be shown in the first column of the footer.', 'theninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    register_sidebar( array(
        'name'          => __( 'Footer Column 2', 'theninja' ),
        'id'            => 'footer-column-2',
        'description'   => __( 'Widgets in this area will be shown in the second column of the footer.', 'theninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    register_sidebar( array(
        'name'          => __( 'Footer Column 3', 'theninja' ),
        'id'            => 'footer-column-3',
        'description'   => __( 'Widgets in this area will be shown in the third column of the footer.', 'theninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );


    register_sidebar( array(
        'name'          => __( 'Footer Column 4', 'theninja' ),
        'id'            => 'footer-column-4',
        'description'   => __( 'Widgets in this area will be shown in the third column of the footer.', 'theninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    register_sidebar( array(
        'name'          => __( 'Footer Column 5', 'theninja' ),
        'id'            => 'footer-column-5',
        'description'   => __( 'Widgets in this area will be shown in the third column of the footer.', 'theninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
}

function add_widgets_to_context($context) {
    $context['footer_column_1'] = Timber::get_widgets('footer-column-1');
    $context['footer_column_2'] = Timber::get_widgets('footer-column-2');
    $context['footer_column_3'] = Timber::get_widgets('footer-column-3');
    $context['footer_column_4'] = Timber::get_widgets('footer-column-4');
    $context['footer_column_5'] = Timber::get_widgets('footer-column-5');

    return $context;
}

function theninja_customizer_settings($wp_customize) {
    
    // Add Logo Section
    $wp_customize->add_section('theninja_logo_section', array(
        'title'       => __('Logo', 'theninja'),
        'priority'    => 30,
        'description' => 'Upload a logo to replace the default site title and description in the header',
    ));

    // Add Logo Setting
    $wp_customize->add_setting('theninja_logo', array(
        'default'     => '',
        'transport'   => 'refresh',
    ));

    // Add Logo Control
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'theninja_logo', array(
        'label'    => __('Logo', 'theninja'),
        'section'  => 'theninja_logo_section',
        'settings' => 'theninja_logo',
    )));

    // Add Favicon Setting
    $wp_customize->add_setting('theninja_favicon', array(
        'default'     => '',
        'transport'   => 'refresh',
    ));

    // Add Favicon Control
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'theninja_favicon', array(
        'label'    => __('Favicon', 'theninja'),
        'section'  => 'theninja_logo_section',
        'settings' => 'theninja_favicon',
    )));

    // Add a section for Typography
    $wp_customize->add_section('theninja_typography_section', array(
        'title'       => __('Typography', 'theninja'),
        'priority'    => 30,
        'description' => 'Customize the fonts used on your site.',
    ));

    // Add Font Family Setting
    $wp_customize->add_setting('theninja_body_font', array(
        'default'     => 'Sans Serif',
        'transport'   => 'refresh',
    ));

    // Add Font Family Control (Dropdown for Font Selection)
    $wp_customize->add_control('theninja_body_font_control', array(
        'label'    => __('Body Font Family', 'theninja'),
        'section'  => 'theninja_typography_section',
        'settings' => 'theninja_body_font',
        'type'     => 'select',
        'choices'  => array(
            'ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"' => 'Sans Serif',
            'Arial, sans-serif' => 'Arial',
            'Georgia, serif' => 'Georgia',
            '"Helvetica Neue", sans-serif' => 'Helvetica Neue',
            'Tahoma, sans-serif' => 'Tahoma',
            'Verdana, sans-serif' => 'Verdana',
            '"Times New Roman", serif' => 'Times New Roman',
        ),
        'transport'   => 'postMessage',
    ));

    // Add Color Section
    $wp_customize->add_section('theninja_color_section', array(
        'title'       => __('Colors', 'theninja'),
        'priority'    => 35,
    ));

    // Add Primary Color Setting
    $wp_customize->add_setting('theninja_primary_color', array(
        'default'     => '#000000',
        'transport'   => 'refresh',
    ));

    // Add Primary Color Control
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'theninja_primary_color_control', array(
        'label'    => __('Primary Color', 'theninja'),
        'section'  => 'theninja_color_section',
        'settings' => 'theninja_primary_color',
    )));

    // Add Secondary Color Setting
    $wp_customize->add_setting('theninja_secondary_color', array(
        'default'     => '#333333',
        'transport'   => 'refresh',
    ));

    // Add Secondary Color Control
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'theninja_secondary_color_control', array(
        'label'    => __('Secondary Color', 'theninja'),
        'section'  => 'theninja_color_section',
        'settings' => 'theninja_secondary_color',
    )));
}

function theninja_add_colors_to_context($context) {
    $context['primary_color'] = get_theme_mod('theninja_primary_color', '#000000');
    $context['secondary_color'] = get_theme_mod('theninja_secondary_color', '#333333');
    
    return $context;
}

function theninja_add_fonts_to_context($context) {
    $context['body_font'] = get_theme_mod('theninja_body_font', 'Arial, sans-serif');
  
    return $context;
}

function theninja_add_logos_to_context($context) {
    $context['logo'] = get_theme_mod('theninja_logo');
    $context['favicon'] = get_theme_mod('theninja_favicon');
  
    return $context;
}

function theninja_customizer_social_media($wp_customize) {

    // Add Social Media Section
    $wp_customize->add_section('theninja_social_media_section', array(
        'title'    => __('Social Media Links', 'theninja'),
        'priority' => 50,
    ));

    // Facebook URL Setting
    $wp_customize->add_setting('theninja_facebook_url', array(
        'default'   => '',
        'transport' => 'refresh',  // Use 'postMessage' for live preview if needed
        'sanitize_callback' => 'esc_url_raw',  // Ensure it's a valid URL
    ));

    // Facebook URL Control
    $wp_customize->add_control('theninja_facebook_url_control', array(
        'label'    => __('Facebook URL', 'theninja'),
        'section'  => 'theninja_social_media_section',
        'settings' => 'theninja_facebook_url',
        'type'     => 'url',  // URL input field
    ));

    // X URL Setting
    $wp_customize->add_setting('theninja_x_url', array(
        'default'   => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    // TwiXtter URL Control
    $wp_customize->add_control('theninja_x_url_control', array(
        'label'    => __('X URL', 'theninja'),
        'section'  => 'theninja_social_media_section',
        'settings' => 'theninja_x_url',
        'type'     => 'url',
    ));

    // Instagram URL Setting
    $wp_customize->add_setting('theninja_instagram_url', array(
        'default'   => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    // Instagram URL Control
    $wp_customize->add_control('theninja_instagram_url_control', array(
        'label'    => __('Instagram URL', 'theninja'),
        'section'  => 'theninja_social_media_section',
        'settings' => 'theninja_instagram_url',
        'type'     => 'url',
    ));

     // LinkedIn URL Setting
     $wp_customize->add_setting('theninja_linkedin_url', array(
        'default'   => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw',
    ));

    // LinkedIn URL Control
    $wp_customize->add_control('theninja_linkedin_url_control', array(
        'label'    => __('LinkedIn URL', 'theninja'),
        'section'  => 'theninja_social_media_section',
        'settings' => 'theninja_linkedin_url',
        'type'     => 'url',
    ));
}


function theninja_add_social_media_to_context($context) {
    // Fetch social media links from the Customizer
    $context['facebook_url'] = get_theme_mod('theninja_facebook_url', '');
    $context['x_url'] = get_theme_mod('theninja_x_url', '');
    $context['instagram_url'] = get_theme_mod('theninja_instagram_url', '');
    $context['linkedin_url'] = get_theme_mod('theninja_linkedin_url', '');

    return $context;
}

function theninja_customize_register($wp_customize) {
    $wp_customize->add_section('theninja_account_section', array(
        'title'    => __('Account Section', 'theninja'),
        'priority' => 130,
    ));

    $wp_customize->add_setting('theninja_hide_account', array(
        'default'   => false,
        'transport' => 'refresh', // This allows us to use JavaScript to update the preview
    ));

    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        'theninja_hide_account_control',
        array(
            'label'    => __('Hide Account', 'theninja'),
            'section'  => 'theninja_account_section',
            'settings' => 'theninja_hide_account',
            'type'     => 'checkbox',
        )
    ));

    $wp_customize->add_section('theninja_login_section', array(
        'title'    => __('Login Page Settings', 'theninja'),
        'priority' => 150,
    ));

    $wp_customize->add_setting('theninja_login_logo', array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'theninja_login_logo_control', array(
        'label'    => __('Login Page Logo', 'theninja'),
        'section'  => 'theninja_login_section',
        'settings' => 'theninja_login_logo',
    )));
}

function add_login_logo_to_context($context) {
    $context['login_logo'] = get_theme_mod('theninja_login_logo', '');
    return $context;
}

function theninja_customize_preview_js() {
    wp_enqueue_script('theninja-customizer', get_template_directory_uri() . '/customizer-preview.js', array('customize-preview', 'jquery'), null, true);
}

function add_account_visibility_to_context($context) {
    $context['hide_account'] = get_theme_mod('theninja_hide_account', false);
    return $context;
}

function theninja_custom_login_logo() {
    $logo_url = get_theme_mod('theninja_login_logo', '');
    if ($logo_url) {
        echo '
        <style type="text/css">
            #login h1 a {
                background-image: url(' . esc_url($logo_url) . ');
                background-size: contain;
                width: 100%;
                height: 100px;
            }
        </style>';
    }
}

function theninja_login_logo_url() {
    return home_url();
}

add_filter('login_headerurl', 'theninja_login_logo_url');

function theninja_login_logo_url_title() {
    return get_bloginfo('name');
}

function theninja_customizer_header_position($wp_customize) {
    // Add Header Position Section
    $wp_customize->add_section('theninja_header_position_section', array(
        'title'    => __('Header Position', 'theninja'),
        'priority' => 30,
    ));

    // Add Checkbox Setting for Fixed Header
    $wp_customize->add_setting('theninja_fixed_header', array(
        'default'     => false,  // Default is unchecked (header not fixed)
        'transport'   => 'refresh',  // Or use 'postMessage' for live preview
    ));

    // Add Checkbox Control for Fixed Header
    $wp_customize->add_control('theninja_fixed_header_control', array(
        'label'    => __('Make Header Fixed', 'theninja'),
        'section'  => 'theninja_header_position_section',
        'settings' => 'theninja_fixed_header',
        'type'     => 'checkbox',  // Checkbox type control
    ));
}

function theninja_add_fixed_header_to_context($context) {
    // Get the value of the fixed header checkbox
    $context['fixed_header'] = get_theme_mod('theninja_fixed_header', false);  // Default is false (not fixed)

    return $context;
}

add_filter('timber/context', 'theninja_add_fixed_header_to_context');

add_action('customize_register', 'theninja_customizer_header_position');

add_filter('login_headertext', 'theninja_login_logo_url_title');

add_action('login_enqueue_scripts', 'theninja_custom_login_logo');

add_filter('timber/context', 'add_login_logo_to_context');

add_filter('timber/context', 'add_account_visibility_to_context');

add_action('customize_preview_init', 'theninja_customize_preview_js');

add_action('customize_register', 'theninja_customize_register');

add_filter('timber/context', 'theninja_add_social_media_to_context');

add_action('customize_register', 'theninja_customizer_social_media');


add_action( 'widgets_init', 'theninja_widgets_init' );
add_action('customize_register', 'theninja_customizer_settings');

add_filter('timber/context', 'add_widgets_to_context');
add_filter('timber/context', 'theninja_add_colors_to_context');
add_filter('timber/context', 'theninja_add_fonts_to_context');
add_filter('timber/context', 'theninja_add_logos_to_context');


//woocommerce

function theme_add_woocommerce_support()
{
    add_theme_support('woocommerce');
}

add_action('after_setup_theme', 'theme_add_woocommerce_support');